////////////////////////////////////////////////
//	File	:	"CNoteManager.h"
//
//	Author	:	Alyssa Dettling (AD)
//
//	Purpose	:	To contain and manage all of our notes
/////////////////////////////////////////////////
#pragma once
#include "CBeatAnalyzer.h"
#include "IListener.h"
#include <vector>
#include <list>
using std::vector;
using std::list;

class CBase;
class CNote;

#define NUM_GOOD_NOTES 250
#define NUM_BAD_NOTES 250

class CNoteManager : public IListener
{
private:
	vector<CBase*> m_vDeadList;
	list<unsigned int> m_vBeatList;
	CBeatAnalyzer* beatAnalyzer;
	int m_nSoundID;
	float m_fUpdateDelay;
	unsigned int m_nLengthOfSong;
	unsigned int m_nCurrentState;
	unsigned int m_nMissedBlack, m_nHitWhite, m_nNotesCreated;
	unsigned int m_nDifficulty;
	float m_fStartLERP;
	float m_fEndLERP;
	float m_fStartVolume;
	char* pSongLocation;
	bool m_bWin;

	///////////////////////////////////////////////////////////////////////////////////
	//  Function: Constructor
	//
	//  Purpose : Creates the object.
	///////////////////////////////////////////////////////////////////////////////////
	CNoteManager(void);
	CNoteManager(CNoteManager&);
	CNoteManager& operator=(CNoteManager&);
	///////////////////////////////////////////////////////////////////////////////////
	//  Function: Destructor
	//
	//  Purpose : Destroys the object.
	///////////////////////////////////////////////////////////////////////////////////
	~CNoteManager(void);

	static CNoteManager* sm_pInstance;

	void SendOutGoodNote(unsigned int position);
	void SendOutNote(unsigned int position);
public:
	///////////////////////////////////////////////////////////////////////////////////
	//  Function: GetInstanec
	//
	//  Purpose : Gets an instance of the object.
	///////////////////////////////////////////////////////////////////////////////////
	static CNoteManager* GetInstance(void);

	///////////////////////////////////////////////////////////////////////////////////
	//  Function: DeleteInstance
	//
	//  Purpose : Deletes the object.
	///////////////////////////////////////////////////////////////////////////////////
	static void DeleteInstance(void);
	///////////////////////////////////////////////////////////////////////////////////
	//  Function: UpdatesObjects
	//
	//  Purpose : Updates the objects.
	///////////////////////////////////////////////////////////////////////////////////
	void UpdateObjects(float fElapsedTime);
	///////////////////////////////////////////////////////////////////////////////////
	//  Function: CheckCollisions
	//
	//  Purpose : Checks collisions on all objects.
	///////////////////////////////////////////////////////////////////////////////////
	void CheckCollisions(void);

	///////////////////////////////////////////////////////////////////////////////////
	//  Function: AddObject
	//
	//  Purpose : Add an object to the manager.
	///////////////////////////////////////////////////////////////////////////////////
	void AddNote(CNote* pObject);

	///////////////////////////////////////////////////////////////////////////////////
	//  Function: RemoveAllObjects
	//
	//  Purpose : Removes all objects from the manager.
	///////////////////////////////////////////////////////////////////////////////////
	void RemoveAllObjects(void);

	void LoadFile1(char* pFileName, unsigned int difficulty);
	void UnloadFile(void);

	void HandleEvent(CEvent* pEvent);

	enum Difficulty{EASY = 0, MEDIUM, HARD};
	enum SongStates{INTRO = 0, RISE, MIDDLE, FALL, END};

	bool GetTempoEstimate(unsigned int &tempo);
	bool GetPercentSongDone(float &percentage);
	unsigned int GetDifficulty(void) { return m_nDifficulty; }
	unsigned int GetCurrentState(void) { return m_nCurrentState; }

	bool DidWin() {return m_bWin;}
};